//@line 4 "/Volumes/BruceDeuce/src/tenfourfox/browser/components/shell/content/setDesktopBackground.js"

var Ci = Components.interfaces;

var gSetBackground = {
//@line 12 "/Volumes/BruceDeuce/src/tenfourfox/browser/components/shell/content/setDesktopBackground.js"
  _position        : "STRETCH",
//@line 14 "/Volumes/BruceDeuce/src/tenfourfox/browser/components/shell/content/setDesktopBackground.js"
  _screenWidth     : 0,
  _screenHeight    : 0,
  _image           : null,
  _canvas          : null,

  get _shell()
  {
    return Components.classes["@mozilla.org/browser/shell-service;1"]
                     .getService(Ci.nsIShellService);
  },

  load: function ()
  {
    this._canvas = document.getElementById("screen");
    this._screenWidth = screen.width;
    this._screenHeight = screen.height;
//@line 31 "/Volumes/BruceDeuce/src/tenfourfox/browser/components/shell/content/setDesktopBackground.js"
    document.documentElement.getButton("accept").hidden = true;
//@line 33 "/Volumes/BruceDeuce/src/tenfourfox/browser/components/shell/content/setDesktopBackground.js"
    if (this._screenWidth / this._screenHeight >= 1.6)
      document.getElementById("monitor").setAttribute("aspectratio", "16:10");

//@line 47 "/Volumes/BruceDeuce/src/tenfourfox/browser/components/shell/content/setDesktopBackground.js"

    // make sure that the correct dimensions will be used
    setTimeout(function(self) {
      self.init(window.arguments[0]);
    }, 0, this);
  },

  init: function (aImage)
  {
    this._image = aImage;

    // set the size of the coordinate space
    this._canvas.width = this._canvas.clientWidth;
    this._canvas.height = this._canvas.clientHeight;

    var ctx = this._canvas.getContext("2d");
    ctx.scale(this._canvas.clientWidth / this._screenWidth, this._canvas.clientHeight / this._screenHeight);

//@line 68 "/Volumes/BruceDeuce/src/tenfourfox/browser/components/shell/content/setDesktopBackground.js"
    // Make sure to reset the button state in case the user has already
    // set an image as their desktop background.
    var setDesktopBackground = document.getElementById("setDesktopBackground");
    setDesktopBackground.hidden = false;
    var bundle = document.getElementById("backgroundBundle");
    setDesktopBackground.label = bundle.getString("DesktopBackgroundSet");
    setDesktopBackground.disabled = false;

    document.getElementById("showDesktopPreferences").hidden = true;
//@line 78 "/Volumes/BruceDeuce/src/tenfourfox/browser/components/shell/content/setDesktopBackground.js"
    this.updatePosition();
  },

//@line 118 "/Volumes/BruceDeuce/src/tenfourfox/browser/components/shell/content/setDesktopBackground.js"
  observe: function (aSubject, aTopic, aData)
  {
    if (aTopic == "shell:desktop-background-changed") {
      document.getElementById("setDesktopBackground").hidden = true;
      document.getElementById("showDesktopPreferences").hidden = false;

      Components.classes["@mozilla.org/observer-service;1"]
                .getService(Ci.nsIObserverService)
                .removeObserver(this, "shell:desktop-background-changed");
    }
  },

  showDesktopPrefs: function()
  {
    this._shell.openApplication(Ci.nsIMacShellService.APPLICATION_DESKTOP);
  },
//@line 135 "/Volumes/BruceDeuce/src/tenfourfox/browser/components/shell/content/setDesktopBackground.js"

  setDesktopBackground: function ()
  {
//@line 142 "/Volumes/BruceDeuce/src/tenfourfox/browser/components/shell/content/setDesktopBackground.js"
    Components.classes["@mozilla.org/observer-service;1"]
              .getService(Ci.nsIObserverService)
              .addObserver(this, "shell:desktop-background-changed", false);

    var bundle = document.getElementById("backgroundBundle");
    var setDesktopBackground = document.getElementById("setDesktopBackground");
    setDesktopBackground.disabled = true;
    setDesktopBackground.label = bundle.getString("DesktopBackgroundDownloading");
//@line 151 "/Volumes/BruceDeuce/src/tenfourfox/browser/components/shell/content/setDesktopBackground.js"
    this._shell.setDesktopBackground(this._image,
                                     Ci.nsIShellService["BACKGROUND_" + this._position]);
  },

  updatePosition: function ()
  {
    var ctx = this._canvas.getContext("2d");
    ctx.clearRect(0, 0, this._screenWidth, this._screenHeight);

//@line 163 "/Volumes/BruceDeuce/src/tenfourfox/browser/components/shell/content/setDesktopBackground.js"

    switch (this._position) {
      case "TILE":
        ctx.save();
        ctx.fillStyle = ctx.createPattern(this._image, "repeat");
        ctx.fillRect(0, 0, this._screenWidth, this._screenHeight);
        ctx.restore();
        break;
      case "STRETCH":
        ctx.drawImage(this._image, 0, 0, this._screenWidth, this._screenHeight);
        break;
      case "CENTER":
        var x = (this._screenWidth - this._image.naturalWidth) / 2;
        var y = (this._screenHeight - this._image.naturalHeight) / 2;
        ctx.drawImage(this._image, x, y);
        break;
      case "FILL":
        //Try maxing width first, overflow height
        var widthRatio = this._screenWidth / this._image.naturalWidth;
        var width = this._image.naturalWidth * widthRatio;
        var height = this._image.naturalHeight * widthRatio;
        if (height < this._screenHeight) {
          //height less than screen, max height and overflow width
          var heightRatio = this._screenHeight / this._image.naturalHeight;
          width = this._image.naturalWidth * heightRatio;
          height = this._image.naturalHeight * heightRatio;
        }
        var x = (this._screenWidth - width) / 2;
        var y = (this._screenHeight - height) / 2;
        ctx.drawImage(this._image, x, y, width, height);
        break;
      case "FIT":
        //Try maxing width first, top and bottom borders
        var widthRatio = this._screenWidth / this._image.naturalWidth;
        var width = this._image.naturalWidth * widthRatio;
        var height = this._image.naturalHeight * widthRatio;
        var x = 0;
        var y = (this._screenHeight - height) / 2;
        if (height > this._screenHeight) {
          //height overflow, maximise height, side borders
          var heightRatio = this._screenHeight / this._image.naturalHeight;
          width = this._image.naturalWidth * heightRatio;
          height = this._image.naturalHeight * heightRatio;
          x = (this._screenWidth - width) / 2;
          y = 0;
        }
        ctx.drawImage(this._image, x, y, width, height);
        break;      
    }
  }
};
